unit Krok5;

interface

uses
  ZamwieniaInterfejsy;

type
  TZamwienie = class(TInterfacedObject, IZamwienie)
    function Warto: integer;
  end;

  TWeryfikacjaZamwienia = class(TInterfacedObject, IWeryfikacjaZamwienia)
    procedure WeryfikujZamwienie(aZamwienie: IZamwienie);
  end;

  TRealizacjaZamwienia = class
  private
    FWeryfikacjaZamwienia: IWeryfikacjaZamwienia;
  public
    constructor Create(aWeryfikacjaZamwienia: IWeryfikacjaZamwienia);
    procedure RealizujZamwienie(aZamwienie: IZamwienie);
  end;

procedure RealizujZamwienia5;

implementation

uses
  System.SysUtils, Spring.Container, Spring.Services;

procedure RealizujZamwienia5;
var
  Zamwienie: IZamwienie;
  WeryfikacjaZamwienia: IWeryfikacjaZamwienia;
  RealizacjaZamwienia: TRealizacjaZamwienia;
begin
  WeryfikacjaZamwienia := ServiceLocator.GetService<IWeryfikacjaZamwienia>;
  RealizacjaZamwienia := TRealizacjaZamwienia.Create(WeryfikacjaZamwienia);
  try
    Zamwienie := TZamwienie.Create;
    RealizacjaZamwienia.RealizujZamwienie(Zamwienie);
  finally
    RealizacjaZamwienia.Free;
  end;
end;

function TZamwienie.Warto: integer;
begin
  Result := Random(1000) + 1
end;

constructor TRealizacjaZamwienia.Create(aWeryfikacjaZamwienia: IWeryfikacjaZamwienia);
begin
  inherited Create;
  FWeryfikacjaZamwienia := aWeryfikacjaZamwienia;
end;

procedure TRealizacjaZamwienia.RealizujZamwienie(aZamwienie:IZamwienie);
begin
  FWeryfikacjaZamwienia.WeryfikujZamwienie(aZamwienie);
end;

procedure TWeryfikacjaZamwienia.WeryfikujZamwienie(aZamwienie: IZamwienie);
begin
  WriteLn('Warto zamwienia: ' + IntToStr(aZamwienie.Warto));
end;

end.
